﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.IO

Public Class MainForm

    '为文件名文本框下面的文本框加载消息。
    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
        '下面的代码使用新的 StringWriter 在内存中生成字符串。
        'WriteLine 命令使用回车符和换行符向字符串缓冲区追加代码。
        Dim writer As StringWriter = New StringWriter()

        With writer
            .WriteLine("Enter a file name & path to test error handling. ")
            .WriteLine("Try different combinations for example:")
            .WriteLine("")
            .WriteLine("  C:\Filename.txt")
            .WriteLine("  C:\FolderName\Filename.txt")
            .WriteLine("  \\ServerName\FolderName\Filename.txt")
        End With

        '要求 StringWriter 将其缓冲区转换为字符串
        Me.txtMessage.Text = writer.ToString()
    End Sub


    Private Sub cmdNoTryCatch_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdNoTryCatch.Click
        '询问以确保用户愿意承担可能出现程序故障的风险。
        Dim message As String = "The following code has no error handling and will cause an unhandled exception if a file is not found. Do you want to continue?"
        If MessageBox.Show(message, Me.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) = Windows.Forms.DialogResult.Yes Then
            '使用 System.IO 命名空间中的 FileStream 类（参见文件顶部的 Imports）。
            Dim fs As FileStream

            '如果文件不存在，此命令将失效。
            fs = File.Open(Me.txtFileName.Text, FileMode.Open)
            MessageBox.Show("The size of the file is: " & fs.Length, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
            fs.Close()

        End If
    End Sub

    Private Sub cmdBasicTryCatch_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdBasicTryCatch.Click
        '此过程将执行基本的 Try-Catch。
        '使用 System.IO 命名空间中的 FileStream 类（参见文件顶部的 Imports）。
        Dim fs As FileStream

        Try
            '如果文件不存在，此命令将失效。
            fs = File.Open(Me.txtFileName.Text, FileMode.Open)
            MessageBox.Show("The size of the file is: " & fs.Length, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
            fs.Close()
        Catch exp As Exception
            '捕获所有未显式捕获的错误。
            MessageBox.Show(exp.Message, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Stop)
        End Try
    End Sub

    Private Sub cmdDetailedTryCatch_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdDetailedTryCatch.Click
        '此过程将执行特定的 Try-Catch，以查找与 IO 相关的所有错误。
        '使用 System.IO 命名空间中的 FileStream 类（参见文件顶部的 Imports）。
        Dim fs As FileStream

        Try
            '如果文件不存在，此命令将失效。
            fs = File.Open(Me.txtFileName.Text, FileMode.Open)
            MessageBox.Show("The size of the file is: " & fs.Length, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
            fs.Close()
        Catch exp As FileNotFoundException
            '请求的文件不存在时将捕获错误。
            MessageBox.Show("The file you requested does not exist.", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Stop)
        Catch exp As DirectoryNotFoundException
            '请求的目录不存在时将捕获错误。
            MessageBox.Show("The directory you requested does not exist.", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Stop)
        Catch exp As IOException
            '捕获任意泛型 IO 异常。
            MessageBox.Show(exp.Message, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Stop)
        Catch exp As Exception
            '捕获所有未显式捕获的错误。
            MessageBox.Show(exp.Message, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Stop)

        End Try
    End Sub

    Private Sub cmdCustomMessage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdCustomMessage.Click
        '此过程将执行特定的 Try-Catch，以查找与 IO 相关的所有错误
        '使用 System.IO 命名空间中的 FileStream 类（参见文件顶部的 Imports）
        Dim fs As FileStream

        Try
            '如果文件不存在，此命令将失效
            fs = File.Open(Me.txtFileName.Text, FileMode.Open)
            MessageBox.Show("The size of the file is: " & fs.Length, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
            fs.Close()
        Catch exp As IOException
            '捕获任意泛型 IO 异常。
            '可以使用 StringWriter 在内存中生成多行字符串。
            '但对于这个简单的消息来说有些小题大做了。
            'FYI StringWriter 来自 System.IO 命名空间。
            Dim message As String
            message = "Unable to open the file you requested, " & Me.txtFileName.Text & vbCrLf & vbCrLf & _
              "Detailed Error Information below:" & vbCrLf & vbCrLf & _
              "  Message: " & exp.Message & vbCrLf & _
              "  Source: " & exp.Source & vbCrLf & vbCrLf & _
              "  Stack Trace:" & vbCrLf

            Dim trace As String

            '访问异常对象 StackTrace 可能导致异常，
            '因此，需要将该调用包装在它自己的 Try-Catch 块中。
            Try
                trace = exp.StackTrace()
            Catch stExp As Security.SecurityException
                trace = "Unable to access stack trace due to security restrictions."
            Catch stExp As Exception
                trace = "Unable to access stack trace."
            End Try

            message = message & trace

            MessageBox.Show(message, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Stop)
        Catch exp As System.Exception
            '此 catch 将捕获任何意外错误。
            MessageBox.Show(exp.Message, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Stop)

        End Try
    End Sub

    Private Sub cmdTryCatchFinally_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdTryCatchFinally.Click
        '此过程先执行基本的 Try-Catch，然后执行 Finally。
        '使用 System.IO 命名空间中的 FileStream 类（参见文件顶部的 Imports）。
        Dim fs As FileStream = Nothing

        Try
            '如果文件不存在，此命令将失效。
            fs = File.Open(Me.txtFileName.Text, FileMode.Open)
            MessageBox.Show("The size of the file is: " & fs.Length, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
        Catch exp As Exception
            '捕获所有未显式捕获的错误。
            MessageBox.Show(exp.Message, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Stop)
        Finally
            '如果文件打开失败，则引用将是 Nothing。
            If Not fs Is Nothing Then
                fs.Close()
                MessageBox.Show("File closed successfully in Finally block", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
            End If
        End Try
    End Sub


    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
